----------------------------------------------------------------------------------------------------------
-- Machine Buttons
----------------------------------------------------------------------------------------------------------
machine_button_assets = {
    button = {
        { state="default", file="button", anim=false },
        { state="over", file="button_over", anim=false },
    },
    button2 = {
        { state="default", file="button", anim=false },
        { state="over", file="button_over", anim=false },
    },
    frame = {
        { state="default", file="gold_frame", anim=false },
    },
    stripe = {
		anim = false,
		{ state="stripe_00", file="stripe_00" },
		{ state="stripe_01", file="stripe_01" },
		{ state="stripe_02", file="stripe_02" },
		{ state="stripe_03", file="stripe_03" },
		{ state="stripe_04", file="stripe_04" },
		{ state="stripe_05", file="stripe_05" },
		{ state="stripe_06", file="stripe_06" },
		{ state="stripe_07", file="stripe_07" },
		{ state="stripe_08", file="stripe_08" },
		{ state="stripe_09", file="stripe_09" },
		{ state="stripe_10", file="stripe_10" },
		{ state="stripe_11", file="stripe_11" },
		{ state="stripe_12", file="stripe_12" },
    },
    icon = {
        anim = false,
        { state="almondpaste", file="almondpaste" },
        { state="almonds", file="almonds" },
        { state="amaretto", file="amaretto" },
        { state="ants", file="ants" },
        { state="banana", file="banana" },
        { state="bar", file="bar" },
        { state="beets", file="beets" },
        { state="bell", file="bell" },
        { state="blackberry", file="blackberry" },
        { state="blueberry", file="blueberry" },
        { state="caramel", file="caramel" },
        { state="cashews", file="cashews" },
        { state="caviar", file="caviar" },
        { state="cherry", file="cherry" },
        { state="cinnamon", file="cinnamon" },
        { state="coconut", file="coconut" },
        { state="coffee", file="coffee_green" },
        { state="currant", file="currant" },
        { state="dark", file="dark" },
        { state="date", file="date" },
        { state="egg", file="egg" },
        { state="fig", file="fig" },
        { state="ginger", file="ginger" },
        { state="greenapple", file="greenapple" },
        { state="greenchili", file="greenchili" },
        { state="inca", file="inca" },
        { state="lemon", file="lemon" },
        { state="milk", file="milk" },
        { state="mint", file="mint" },
        { state="nutmeg", file="nutmeg" },
        { state="orange", file="orange" },
        { state="pistachio", file="pistachio" },
        { state="raisins", file="raisins" },
        { state="raspberry", file="raspberry" },
        { state="saffron", file="saffron" },
        { state="scarab", file="scarab" },
        { state="sourcream", file="sourcream" },
        { state="tea", file="tea" },
        { state="truffle", file="truffle" },
        { state="volcano", file="volcano" },
        { state="whale", file="whale" },
        { state="white", file="white" },
        { state="yellowcurry", file="yellowcurry" },
        { state="yogurt", file="sourcream" },
    }
}

----------------------------------------------------------------------------------------------------------
-- Mix Fill Machine
----------------------------------------------------------------------------------------------------------
machine_mixer_style = {
	baseDir     = "anim/machines/mixer/",
    name        = "machine_mixer",
    type        = "machine",
    spriteLayer	= 7,
    chocolate	= {204,492},
    
	assets = {
		base = {
			{ state="default", file="mixer_base", base=2},
		},
	},
	children = {
		leaf = true,
		armtainer = {
			layer = 0,
			assets = {
				base = {
					{ state="default", file="mixer_base", base=0 },
				},
			},
		},
		panel = {
		    --x = -10,
		    --y = 0,
		    name = "mixer_panel",
			layer = 5,
			assets = {
				base = {
					{ state="default", file="mixer_base", base=1 },
				},
			},
		},
		--[[tank1 = {
			layer = 0,
			visible = false,
			assets = {
				base = {
					{ state="default", file="mixer_base", base=1 },
				},
			},
		},
		tank2 = {
			layer = 0,
			visible = false,
			assets = {
				base = {
					{ state="default", file="mixer_base", base=2 },
				},
			},
		},
		tank3 = {
			layer = 0,
			visible = false,
			assets = {
				base = {
					{ state="default", file="mixer_base", base=4 },
				},
			},
		},]]
		anim_arm = {
			x = 2,
			y = 24,
			layer = 4,
			assets = {
				anim = {
					{ state="default", file="mixer_arm" },
				},
			},
		},
		anim_tube = {
			name = "machine_tube",
			x = 119,
			y = 322,
			scale = {0.96,1.0},
			layer = 3,
			assets = {
				anim={
					{ state="option_0", file="mixer_tube_dark" },
					{ state="option_1", file="mixer_tube_milk" },
					{ state="option_2", file="mixer_tube_white" },
				},
			},
		},
		anim_spray = {
			x = 3 + 2,
			y = 2 + 24,
			layer = 3,
			assets = {
				anim={
					{ state="option_0", file="mixer_pour_dark" },
					{ state="option_1", file="mixer_pour_milk" },
					{ state="option_2", file="mixer_pour_white" },
				},
			},
		},
	},
}
----------------------------------------------------------------------------------------------------------
-- Ingredient Machine
----------------------------------------------------------------------------------------------------------
machine_ingredient_style = {
	baseDir     = "anim/machines/ingredient/",
    name        = "machine_ingredient",
    type        = "machine",
    spriteLayer	= 7,
    chocolate	= {317,518},
    assets = {
		base={
			{ state="default", file="ingred_base", base=0 },
		},
	},
	children = {
		leaf = true,
		panel={
			layer = 0,
			assets = {
				anim = {
					{ state="default", file="ingred_base", base=1 },
				}
			}
		},
		shadow = {
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="ingred_base", base=2 },
				}
			}
		},
		anim_intro = {
			layer = 3,
			x = 3,
			y = -3,
			assets = {
				anim = {
					{ state="default", file="ingred_intro" },
				},
			},
		},
		anim_pump = {
			layer = 4,
			x = 3,
			y = -3,
			assets = {
				anim = {
					{ state="default", file="ingred_pump" },
				},
			},
		},
		static_top1 = {
			x = 266,
			y = 469,
			layer = 4,
			assets = {
				anim = {
					{ state="upgrade1", file="ingred_base", base=3 },
					{ state="upgrade2", file="ingred_base", base=4 },
					{ state="upgrade3", file="ingred_base", base=5 },
				},
			},
		},
		static_top2 = {
			x = 369,
			y = 469,
			layer = 4,
			assets = {
				anim = {
					{ state="upgrade1", file="ingred_base", base=3 },
					{ state="upgrade2", file="ingred_base", base=4 },
					{ state="upgrade3", file="ingred_base", base=5 },
				},
			},
		},
		anim_top1 = {
			x = 266,
			y = 469,
			layer = 4,
			assets = {
				anim = {
					{ state="upgrade1", file="ingred_top_01" },
					{ state="upgrade2", file="ingred_top_02" },
					{ state="upgrade3", file="ingred_top_03" },
				},
			},
		},
		anim_top2 = {
			x = 369,
			y = 469,
			layer = 4,
			assets = {
				anim = {
					{ state="upgrade1", file="ingred_top_01" },
					{ state="upgrade2", file="ingred_top_02" },
					{ state="upgrade3", file="ingred_top_03" },
				},
			},
		},
	},
}
----------------------------------------------------------------------------------------------------------
-- Press Machine
----------------------------------------------------------------------------------------------------------
machine_press_style = {
	baseDir     = "anim/machines/press/",
    name        = "machine_press",
    type		= "machine",
    spriteLayer	= 7,
    chocolate	= {420, 530},
	assets = {
		base = {
			{ state="default", file="press_base", base=3 },
		},
	},
	children = {
		leaf = true;
		door_front = {
			layer = 5,
			assets = {
				anim = {
					{ state="default", file="press_base", base=6 },
				}
			}
		},
		static_door = {
			layer = 0,
			assets = {
				anim = {
					{ state="default", file="press_base", base=5 },
				}
			}
		},
		anim_door = {
			layer = 0,
			assets = {
				anim = {
					{ state="default", file="press_misc", base=0 },
				}
			}
		},
		panel = {
			layer = 5,
			assets = {
				anim = {
					{ state="default", file="press_base", base=0 },
				}
			}
		},
		sidetank = {
		    x = -3,
		    y = 2,
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="press_base", base=2 },
				}
			}
		},
		static_wheel = {
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="press_base", base=7 },
				}
			}
		},
		anim_wheel = {
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="press_misc" },
				}
			}
		},
		static_largeweight = {
			layer = 2,
			assets = {
				anim = {
					{ state="default", file="press_base", base=1 },
				}
			}
		},
		anim_largeweight = {
			layer = 2,
			assets = {
				anim = {
					{ state="default", file="press_large" },
				}
			}
		},
		anim_fill = {
			layer = 1,
			assets = {
				anim = {
					{ state="default", file="press_fill" },
				}
			}    
		},
		top = {
			layer = 0,
			assets = {
				anim = {
					{ state="default", file="press_base", base=8 },
				},
			},
		},
	},
}
----------------------------------------------------------------------------------------------------------
-- Topping Machine
----------------------------------------------------------------------------------------------------------
machine_topping_style = {
	baseDir     = "anim/machines/topping/",
    name        = "machine_topping",
    type        = "machine",
    spriteLayer	= 7,
    chocolate	= {420, 530},
    
	assets = {
		base={
			{ state="default", file="topping_base", base=2 },
		},
	},
	children = {
		leaf = true;
		tubes = {
			layer = -2,
			assets = {
				anim = {
					{ state="default", file="topping_base", base=0 },
				}
			}
		},
		pipes = {
			layer = -3,
			assets = {
				anim = {
					{ state="default", file="topping_base", base=1 },
				}
			}
		},
		static_funnel = {
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="topping_base", base=3 },
				}
			}
		},
		anim_funnel = {
			layer = -1,
			assets = {
				anim = {
					{ state="default", file="topping_misc", base=31 },
				}
			}
		},
		anim_particles = {
			layer = 2,
			assets = {
				anim = {
					{ state="default", file="topping_misc", base=0 },
				},
			},
		},
		shadow = {
			layer = -4,
			assets = {
				anim = {
					{ state="default", file="topping_base", base=4 },
				}
			}
		},
		panel = {
			layer = 5,
			assets = {
				anim = {
					{ state="default", file="topping_base", base=5 },
				},
			},
		},
	},
}
----------------------------------------------------------------------------------------------------------
-- Infusion Machine
----------------------------------------------------------------------------------------------------------
machine_infusion_style = {
	x = 10, y = -25,
    baseDir     = "anim/machines/infuse/",
    name        = "machine_infusion",
    type		= "machine",
    spriteLayer	= 7,
    chocolate	= {420, 530},
    
	assets = {
		base={
			{ state="default", file="infuse_base", base=0},
		},
	},
	children = {
		leaf = true,
		static_top = {
			layer = 1,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=1},
				},
			},
		},
		static_base = {
			x = -20, y = 44,
			layer = 1,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=2},
				},
			},
		},
		door_front = {
			x = -20, y = 44,
			layer = 3,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=3},
				},
			},
		},
		anim_door = {
			x = -20, y = 44,
			layer = 1,
			assets = {
				anim = {
					{ state="default", file="infuse_misc", base=0},
				},
			},
		},
		anim_top_working = {
			layer = 1,
			assets = {
				anim = {
					{ state="default", file="infuse_misc", base=7},
				},
			},
		},
		anim_base = {
			layer = 0,
			assets = {
				anim = {
					{ state="default", file="base_working"},
				},
			},
		},
		shadow = {
			layer = -5,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=4},
				},
			},
		},
		panel1 = {
			x = -10, y = 29,
			layer = 5,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=5},
				},
			},
		},
		panel2 = {
			x = -10, y = 29,
			layer = 5,
			assets = {
				anim = {
					{ state="default", file="infuse_base", base=6},
				},
			},
		},
	},
}			
----------------------------------------------------------------------------------------------------------
-- Disposal Machine
----------------------------------------------------------------------------------------------------------
machine_disposal_assets = {
	base={
		{ state="default", file="disposal_base", base=0 },
	},
}
machine_disposal_children = {
    leaf = true,
    active = {
        assets = {
            base = {
                { state="default", file="disposal_base", base=1, play="DoAnim" },
            },
        },
    }   
}

----------------------------------------------------------------------------------------------------------
-- Delivery Machine
----------------------------------------------------------------------------------------------------------
machine_delivery_style = {
    baseDir     = "anim/machines/delivery/",
    name        = "machine_delivery",
	type		= "machine",
	spriteLayer	= 3,
	
	assets = {
		base={
			{ state="default", file="delivery_base", base=1},
		},
	},
    bubble = {
		baseDir = "anim/customers/",
		anchor = "thought",
		hflip = true,
		leaf = true,
		assets = {
			bubble_single = {
				{ state = "happy", file = "thoughtbubble", base=0 },
			    { state = "content", file = "thoughtbubble", base=1 },
			    { state = "neutral", file = "thoughtbubble", base=2 },
			    { state = "annoyed", file = "thoughtbubble", base=3 },
			    { state = "angry", file = "thoughtbubble", base=4 },
			},
		},
	},
	children = {
		leaf = true,
		anim_boxing_back = {
			layer = 0,
			assets = {
				anim = {
					{state="default", file="delivery_working"},
				},
			},
		},
		anim_boxing_front = {
			x = 616-40, y = 215-35,
			layer = 2,
			assets = {
				anim = {
					{state="default", file="delivery_working"},
				},
			},
		},
		shadow = {
			layer = -1,
			assets = {
				anim = {
					{state="default", file="delivery_base", base=0},
				},
			},
		},
	},
}

----------------------------------------------------------------------------------------------------------
-- Sauce Machine
----------------------------------------------------------------------------------------------------------
machine_sauce_style = {
	stationType = kSauce,
    baseDir     = "anim/machines/sauce/",
    name        = "machine_sauce",
    type		= "machine",
    spriteLayer	= 3,
    
    assets = {
		base={
			{ state="default", file="sauce_base", base=11 },
		},
	},
	children = {
		leaf = true,
		glass = {
		    layer = 2,
		    assets = {
		        base = {
		            { state="default", file="sauce_base", base=22 },
		        }
		    }
		},
		--------------------------- sauce filling animation
		static_fill = {
			layer = 1,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=12 },
				},
			},
		},
		anim_fill = {
			layer = 1,
			assets = {
				base = {
					{ state="default", file="sauce_fill" },
				},
			},
		},
		--------------------------- Blue Top Piece (retracted)
		static_top = {
			layer = 5,
			assets ={
				base = {
					{ state="default", file="sauce_base", base=1 },
				},
			},
		},
		anim_top = {
			layer = 5,
			assets = {
				base = {
					{ state="default", file="sauce_blue_top" },
				},
			},
		},
		--------------------------- Spray animation
		anim_spray = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="sauce_base" },
				},
			},
		},
		--------------------------- Sauce Dispenser
		static_dispenser = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=0},
				},
			},
		},
		anim_dispenser = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="sauce_dispenser" },
				},
			},
		},
		shadow = {
			layer = -1,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=30 },
				},
			},
		},
		bottle = {
			leaf = true,
			layer = 4,
			name = "sauce_bottle",
			type = "sauce",
			anchor = "bottle",
			visible = false,
			assets = {
				base = {
					{ state="default", file="sauce_bottle"},
				},
			},
		},
	},
}
----------------------------------------------------------------------------------------------------------
-- Drink Machine
----------------------------------------------------------------------------------------------------------
machine_drink_style = {
	stationType = kDrink,
    baseDir     = "anim/machines/sauce/",
    name        = "machine_drink",
    type		= "machine",
	spriteLayer	= 3,
	
	assets = {
		base={
			{ state="default", file="sauce_base", base=11 },
		},
	},
	children = {
		leaf = true,
		glass = {
		    layer = 2,
		    assets = {
		        base = {
		            { state="default", file="sauce_base", base=22 },
		        }
		    }
		},
		--------------------------- sauce filling animation
		static_fill = {
			layer = 1,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=12 },
				},
			},
		},
		anim_fill = {
			layer = 1,
			assets = {
				base = {
					{ state="default", file="sauce_fill" },
				},
			},
		},
		--------------------------- Red Top Piece (retracted)
		static_top = {
			layer = 5,
			assets ={
				base = {
					{ state="default", file="sauce_base", base=28 },
				},
			},
		},
		anim_top = {
			layer = 5,
			assets = {
				base = {
					{ state="default", file="sauce_red_top" },
				},
			},
		},
		--------------------------- Spray animation
		anim_spray = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=14 },
				},
			},
			children = {
				cup = {
					layer = -1,
					assets = {
						default = {
							{ state="default", file="sauce_base", base=21 },
						},
					},
				},
			},
		},
		anim_fill_steam = {
			layer = 3,
			mouse=false,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=23},
				},
			},
		},
		--------------------------- Sauce Dispenser
		static_dispenser = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=0},
				},
			},
		},
		anim_dispenser = {
			layer = 3,
			assets = {
				base = {
					{ state="default", file="cup_dispenser" },
				},
			},
		},
		shadow = {
			layer = -1,
			assets = {
				base = {
					{ state="default", file="sauce_base", base=30 },
				},
			},
		},
		bottle = {
			layer = 4,
			name = "drink_cup",
			type = "drink",
			anchor = "bottle",
			visible = false,
			leaf = true,
			assets = {
				base = {
					{ state="default", file="drink_cup", base=5 },
				},
			},
			children = {
				steam = {
					layer = 1,
					continuous = true,
					mouse = false,
					leaf = false,
					assets = {
						anim = {
							{ state="default", file="drink_cup", play="DoAnim" },
						},
					},    
				},
			},
		},
	},
}

machine_booster = {
    baseDir = "anim/machines/",
    name = "steam_booster",
    upgrade = "kSteam1",
    category = "gameplay",
    spriteLayer = 7,
    scale = {0.8, 0.8},
    x = 0, y = 140,
    assets = {
	    shadow = {
	        { state="default",  file="booster_base", base=13 },
        },
    },
    children = {
        visible = true,
        steam = {
            layer = 4,
            continuous = true,
            assets = {
                anim = {
                    { state="default", file="booster_base", play="DoSteam" },
                },
            },
        },
        pipes_left = {
            layer = 1,
            assets = {
                anim = {
                    { state="default", file="booster_base", base=11 },
                },
            },
        },
        pipes_right = {
            layer = 3,
            assets = {
                anim = {
                    { state="default", file="booster_base", base=12 },
                },
            },
        },
        base = {
            layer = 2,
            continuous = true,
            assets = {
                anim = {
                    { state="default", file="booster_base", play="DoAnim" },
                },
            },
        },
    },
}
------------------------------------------ kPhonograph1 phonograph
machine_phono = {
    baseDir = "anim/machines/",
    name = "phonograph",
    upgrade = "kPhonograph1",
    category = "gameplay",
    spriteLayer = 5,
    mouse = false,
    scale = {0.75, 0.75},
    --x = 800 * 0.25,
    y = 600 * 0.25,
    assets = {
	    shadow = {
	        { state="default",  file="phono_base", base=0 },
        },
    },
    children = {
        visible = true,
        continuous = true,
        top = {
            layer = 2,
            assets = {
                anim = {
                    { state="default", file="phono_anim", play="DoAnim", base=17 },
                },
            },
        },
        crank = {
            layer = 1,
            assets = {
                anim = {
                    { state="default", file="phono_anim", play="DoCrank", base=0 },
                },
            },
        },
        needle = {
            layer = 1,
            assets = {
                anim = {
                    { state="default", file="phono_anim", play="DoNeedle", base=11 },
                },
            },
        },
    },
}